'use strict';

/* --------------------------------------------------------------
   account_emailaddress.js 2020-02-26
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

gambio.widgets.module('account_emailaddress', [], function (data) {
	'use strict';

	var $this = $(this),
	    $body = $('body'),
	    defaults = {},
	    options = $.extend(true, {}, defaults, data),
	    module = {};

	// ########## HELPER FUNCTIONS ##########

	// (none)

	// ########## INITIALIZATION ##########

	/**
  * Init function of the widget
  * @constructor
  */
	module.init = function (done) {
		var $emailAddress = $('#email_address'),
		    $emailConfirm = $('#email_address_confirm'),
		    $emailInputs = $('#email_address, #email_address_confirm'),
		    $noMatchNote = $('.email-no-match');

		$emailInputs.on('input', function () {
			var emailValue = $emailAddress.val(),
			    confirmValue = $emailConfirm.val();
			console.log('*************************************************************************************************************************');
			console.log('********************************************************* input has changed *********************************************');
			console.log('*************************************************************************************************************************');
			if ((emailValue.length > 0 || confirmValue.length > 0) && emailValue !== confirmValue) {
				$noMatchNote.show();
				$emailAddress.closest('div.form-group').addClass('has-error');
				$emailConfirm.closest('div.form-group').addClass('has-error');
			} else {
				$noMatchNote.hide();
				$emailAddress.closest('div.form-group').removeClass('has-error');
				$emailConfirm.closest('div.form-group').removeClass('has-error');

				// remove help text indicating email address already exists
				$emailAddress.closest('div.form-group').find('.help-block').remove();
				$emailConfirm.closest('div.form-group').find('.help-block').remove();
				// check if password is okay and enable submit button upon a valid password
				if (!$('#password-option').hasClass('has-error')) {
					$('button[type="submit"]', $this.closest('form')).removeAttr('disabled');
				}
			}
		});

		done();
	};

	// Return data to widget engine
	return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
